const storageApi = (typeof browser !== 'undefined' && browser.storage) ? browser.storage : chrome.storage;
const tabsApi = (typeof browser !== 'undefined' && browser.tabs) ? browser.tabs : chrome.tabs;

function closeTab() {
    try {
        tabsApi.getCurrent(function(tab) {
            if (tab && tab.id) {
                tabsApi.remove(tab.id);
            }
        });
    } catch(e) {
        window.close();
    }
}

document.getElementById('accept-btn').addEventListener('click', async () => {
    try {
        await storageApi.local.set({ dataConsentGiven: true, dataConsentTimestamp: Date.now() });
    } catch(e) {
        console.error('CarbonGuru: Failed to save consent:', e);
    }
    closeTab();
});

document.getElementById('decline-btn').addEventListener('click', async () => {
    try {
        await storageApi.local.set({ dataConsentGiven: false, dataConsentTimestamp: Date.now() });
    } catch(e) {
        console.error('CarbonGuru: Failed to save consent:', e);
    }
    closeTab();
});
